import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:permission_handler/permission_handler.dart';
import 'package:viserpay_agent/core/helper/string_format_helper.dart';
import 'package:viserpay_agent/core/route/route.dart';
import 'package:viserpay_agent/core/utils/app_dialog.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/my_color.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/core/utils/style.dart';
import 'package:viserpay_agent/core/utils/util.dart';
import 'package:viserpay_agent/data/controller/cash_in/cash_in_controller.dart';
import 'package:viserpay_agent/view/components/bottom-sheet/custom_bottom_sheet.dart';
import 'package:viserpay_agent/view/components/buttons/gradient_rounded_button.dart';
import 'package:viserpay_agent/view/components/custom_loader/custom_loader.dart';
import 'package:viserpay_agent/view/components/snack_bar/show_custom_snackbar.dart';
import 'package:viserpay_agent/view/components/text-form-field/custom_amount_text_field.dart';
import 'package:viserpay_agent/view/components/text-form-field/custom_text_field.dart';
import 'package:viserpay_agent/view/components/text-form-field/text_field_person_validity_widget.dart';
import 'package:viserpay_agent/view/components/text/label_text.dart';
import 'package:viserpay_agent/view/screens/money_in/widget/money_in_otp_bottom_sheet.dart';
import 'package:viserpay_agent/view/screens/transaction/widget/filter_row_widget.dart';

class CashInForm extends StatefulWidget {
  const CashInForm({super.key});

  @override
  State<CashInForm> createState() => _CashInFormState();
}

class _CashInFormState extends State<CashInForm> {
  final formKey = GlobalKey<FormState>();

  @override
  Widget build(BuildContext context) {
    return GetBuilder<CashInController>(
      builder: (controller) => Form(
        key: formKey,
        child: controller.isLoading
            ? const CustomLoader()
            : Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  const SizedBox(height: Dimensions.space15),
                  Focus(
                    onFocusChange: (hasFocus) {
                      if (!hasFocus) {
                        controller.checkAgentFocus(hasFocus);
                      }
                    },
                    child: CustomTextField(
                      needOutlineBorder: true,
                      labelText: MyStrings.usernameOrNumber.tr,
                      hintText: MyStrings.usernameOrNumber.tr,
                      onChanged: (value) {},
                      controller: controller.userController,
                      isShowSuffixIcon: true,
                      onSuffixTap: () {},
                      sufixIcon: GestureDetector(
                        behavior: HitTestBehavior.translucent,
                        onTap: () async {
                          await MyUtils().isCameraPemissonGranted().then((value) {
                            if (value == PermissionStatus.granted) {
                              Get.toNamed(RouteHelper.qrCodeScanner)?.then((value) {
                                if (value.toString() != "-1") {
                                  controller.changeUserNumber(value);
                                  controller.checkAgentFocus(true);
                                } else {
                                  AppDialog().unaValableQrCode(MyStrings.scanUserQrCode, RouteHelper.qrCodeScanner, false);
                                }
                              });
                            } else {
                              AppDialog().permissonQrCode();
                            }
                          });
                        },
                        child: const Icon(
                          Icons.qr_code_scanner,
                          color: MyColor.primaryColor,
                        ),
                      ),
                    ),
                  ),
                  const SizedBox(height: Dimensions.space5),
                  TextFieldPersonValidityWidget(
                    isVisible: controller.isUserFound,
                    validMsg: controller.validUser,
                    invalidMsg: controller.invalidUser,
                  ),
                  const SizedBox(height: Dimensions.space15),
                  CustomAmountTextField(
                    labelText: MyStrings.amount.tr,
                    hintText: MyStrings.amountHint.tr,
                    onChanged: (value) {
                      if (value.toString().isEmpty) {
                        controller.changeInfoWidget(0);
                      } else {
                        double amount = double.tryParse(value.toString()) ?? 0;
                        controller.changeInfoWidget(amount);
                      }
                    },
                    currency: controller.currency,
                    controller: controller.amountController,
                  ),
                  const SizedBox(height: Dimensions.space5),
                  Text(
                    "${MyStrings.limit.tr}: ${controller.minLimit} - ${controller.maxLimit} ${controller.currency}",
                    style: regularExtraSmall.copyWith(color: MyColor.primaryColor),
                  ),
                  const SizedBox(height: Dimensions.space15),
                  Visibility(
                    visible: controller.otpTypeList.length > 1,
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        const LabelText(text: MyStrings.selectOtp),
                        const SizedBox(height: Dimensions.textToTextSpace),
                        FilterRowWidget(borderColor: controller.selectedOtp == MyStrings.selectOtp ? MyColor.textFieldDisableBorderColor : MyColor.textFieldEnableBorderColor, text: controller.selectedOtp.toTitleCase(), press: () => CustomBottomSheet(child: const CashInOtpBottomSheet()).customBottomSheet(context)),
                      ],
                    ),
                  ),
                  const SizedBox(height: Dimensions.space30),
                  GradientRoundedButton(
                    showLoadingIcon: controller.submitLoading,
                    press: () {
                      if (controller.submitLoading) {
                        return;
                      }
                      if (controller.userController.text.isEmpty) {
                        CustomSnackBar.error(errorList: [MyStrings.enterEmailOrUserName.tr]);
                      } else if (controller.amountController.text.isEmpty) {
                        CustomSnackBar.error(errorList: [MyStrings.enterAmount.tr]);
                      } else {
                        controller.submitCashIn();
                      }
                    },
                    text: MyStrings.cashIn.tr,
                  )
                ],
              ),
      ),
    );
  }
}
